/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.AppWindowEvent;
import apiipc.generated.events.AppWindowEventListener;
import apiipc.generated.ui.AppWindow;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppWindowEventRegistry
extends IPCEventRegistry {
    protected Set<AppWindowEventListener> globalListeners = new HashSet<AppWindowEventListener>();
    protected Map<String, Set<AppWindowEventListener>> specificObjectListeners = new HashMap<String, Set<AppWindowEventListener>>();

    public AppWindowEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "AppWindow";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        AppWindowEvent appWindowEvent = null;
        if (string.equalsIgnoreCase("fileNewed")) {
            appWindowEvent = new AppWindowEvent.FileNewed(iPCEventLTV);
        } else if (string.equalsIgnoreCase("fileOpened")) {
            appWindowEvent = new AppWindowEvent.FileOpened(iPCEventLTV);
        } else if (string.equalsIgnoreCase("fileSaved")) {
            appWindowEvent = new AppWindowEvent.FileSaved(iPCEventLTV);
        } else if (string.equalsIgnoreCase("fileSaveDone")) {
            appWindowEvent = new AppWindowEvent.FileSaveDone(iPCEventLTV);
        } else if (string.equalsIgnoreCase("fileSaveToBytesDone")) {
            appWindowEvent = new AppWindowEvent.FileSaveToBytesDone(iPCEventLTV);
        } else if (string.equalsIgnoreCase("appExit")) {
            appWindowEvent = new AppWindowEvent.AppExit(iPCEventLTV);
        } else {
            return;
        }
        for (AppWindowEventListener object : this.globalListeners) {
            object.handleEvent(appWindowEvent);
        }
        Set<AppWindowEventListener> set = this.specificObjectListeners.get(appWindowEvent.objectUUID.toString());
        if (set != null) {
            for (AppWindowEventListener appWindowEventListener : set) {
                appWindowEventListener.handleEvent(appWindowEvent);
            }
        }
    }

    public void addListenerFiltered(AppWindowEventListener appWindowEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("fileNewed");
                this.register("fileOpened");
                this.register("fileSaved");
                this.register("fileSaveDone");
                this.register("fileSaveToBytesDone");
                this.register("appExit");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(appWindowEventListener);
    }

    public void addSpecificListenerFiltered(AppWindowEventListener appWindowEventListener, AppWindow appWindow, List<String> list) throws IOException {
        UUID uUID = appWindow.getObjectUUID();
        String string = uUID.toString();
        Set<AppWindowEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<AppWindowEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "fileNewed");
                this.register(uUID, "fileOpened");
                this.register(uUID, "fileSaved");
                this.register(uUID, "fileSaveDone");
                this.register(uUID, "fileSaveToBytesDone");
                this.register(uUID, "appExit");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(appWindowEventListener);
    }

    public void removeListenerFiltered(AppWindowEventListener appWindowEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("fileNewed");
                this.deregister("fileOpened");
                this.deregister("fileSaved");
                this.deregister("fileSaveDone");
                this.deregister("fileSaveToBytesDone");
                this.deregister("appExit");
            }
            this.globalListeners.remove(appWindowEventListener);
        }
    }

    public void removeSpecificListenerFiltered(AppWindowEventListener appWindowEventListener, AppWindow appWindow, List<String> list) throws IOException {
        UUID uUID = appWindow.getObjectUUID();
        String string = uUID.toString();
        Set<AppWindowEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "fileNewed");
            this.deregister(uUID, "fileOpened");
            this.deregister(uUID, "fileSaved");
            this.deregister(uUID, "fileSaveDone");
            this.deregister(uUID, "fileSaveToBytesDone");
            this.deregister(uUID, "appExit");
            set.remove(appWindowEventListener);
        }
    }

    public void addListener(AppWindowEventListener appWindowEventListener) throws IOException {
        this.addListenerFiltered(appWindowEventListener, null);
    }

    public void addListener(AppWindowEventListener appWindowEventListener, AppWindow appWindow) throws IOException {
        this.addSpecificListenerFiltered(appWindowEventListener, appWindow, null);
    }

    public void removeListener(AppWindowEventListener appWindowEventListener) throws IOException {
        this.removeListenerFiltered(appWindowEventListener, null);
    }

    public void removeListener(AppWindowEventListener appWindowEventListener, AppWindow appWindow) throws IOException {
        this.removeSpecificListenerFiltered(appWindowEventListener, appWindow, null);
    }
}

